%% Description
% Plots figure 12: the evolution of the adhesive force to its equilibrium
% value, calculated numerically, plotted against the long-time asymptotic
% dimple solution.

%% Parameter Definitions
%
% G     Values of \Gamma.
%
% Hinf  Values of H_\infty.
%
% F     The adhesion force as calculated by the dynamical numerics.
%
% t     The time of the corresponding adhesion force.
%
% f     The equilibrium value of the adhesion force.
%
% col   Colour scheme for plot.

clear all;close all

%% Load data
load('figure12.mat')

%% Plotting
% Plot main figure
figure(1)
%col = ['b' 'g' 'r'];
col=parula(7);

for i = 1:3
loglog(t(:,i),f(i)-F(:,i),'color',col(2*i-1,:)), hold on
loglog(t(:,i),dF(i).*t(:,i).^(-0.25),'color',col(2*i-1,:),'linestyle','--',...
            'handlevisibility','off')
end

% Add legend, axis labels, etc
legend('\Gamma = 10, H_\infty=2.5','\Gamma = 20, H_\infty = 3',...
    '\Gamma = 100, H_\infty = 5','location',[.2 .7 .2 .2])
xlabel('$t$','interpreter','latex')
ylabel('$F_\infty-F(t)$','interpreter','latex')
axis([1e0 1e5 1e-5 1e1])

% Increase axis label size
set(findobj('type','axes'),'fontsize',20,'linewidth',2)

% Increase tick length
set(gca,'TickLength',2*get(gca,'TickLength'))

% Plot inset
figure(2)
plot(t(:,1).^(-0.5),(f(1)-F(:,1)-dF(1).*t(:,i).^(-0.25)),strcat(col(7,:),'-'))
hold on
xvals=linspace(0,0.5,10);
plot(xvals,0.04*xvals,'k--')
set(gca,'TickLength',2*get(gca,'TickLength'))
% xticks([0 0.25 0.5])
% yticks([0 0.025 0.05])
axis([0 0.5 0 0.05])
xlabel('$t^{-1/2}$','interpreter','latex'), ylabel('Error') 
hold off

    